-- JOINS --
-- 1) INNER JOIN:
-- eleen kaytlar getirir (eleen kaytlar kural zerinden)
-- iki veya daha fazla tabloyu eleen kaytlar kural zerinden tek bir tabloymu gibi birletiriyor
-- burda eleen kaytlar kural: f.yonetmen_id = y.id
use Filmler
select f.id as filmid, f.adi as filmadi, f.yapimyili as filmyapimyili, f.gisesi as filmgisesi,
y.adi as filmyonetmenadi, y.soyadi as filmyonetmensoyadi
from Film as f inner join Yonetmen as y on f.yonetmen_id = y.id order by f.yapimyili
go
select Yonetmen.adi from Film inner join Yonetmen on Film.yonetmen_id = Yonetmen.id
go
select distinct Yonetmen.adi from Film inner join Yonetmen on Film.yonetmen_id = Yonetmen.id
-- distinct kendisinden sonraki stun adna gre tekrarlayan satrlar yerine unique satrlar getirir
-- (ilk karlat unique satrlar getirir, dier ayn deerdeki satrlar getirmez)
select f.id as filmid, f.adi as filmadi, f.yapimyili as filmyapimyili, f.gisesi as filmgisesi,
y.adi + ' ' + y.soyadi as filmyonetmeni, 
o.adi + ' ' + o.soyadi as filmoyuncusu
from Yonetmen as y, Film as f, FilmOyuncuKarakter as fok, Oyuncu as o
where y.id = f.yonetmen_id
and f.id = fok.film_id
and fok.oyuncu_id = o.id
go
select f.id as filmid, f.adi as filmadi, f.yapimyili as filmyapimyili, f.gisesi as filmgisesi,
y.adi + ' ' + y.soyadi as filmyonetmeni, 
o.adi + ' ' + o.soyadi as filmoyuncusu
from Yonetmen as y inner join Film as f on y.id = f.yonetmen_id 
inner join FilmOyuncuKarakter as fok on f.id = fok.film_id 
inner join Oyuncu as o on fok.oyuncu_id = o.id
-- iki komut da INNER JOIN! --
-- INNER JOIN eleme kuralnda null olan kaytlar getirmez
-- bir tablo kendisine de INNER JOIN yapabilir
-- Soru: Ad M ile balayan oyuncularn oynad filmler?
select Oyuncu.adi + ' ' + Oyuncu.soyadi as oyuncu, Film.adi as filmadi 
from Film inner join FilmOyuncuKarakter on Film.id = FilmOyuncuKarakter.film_id
inner join Oyuncu on FilmOyuncuKarakter.oyuncu_id = Oyuncu.id
where Oyuncu.adi like 'm%'
go
select Oyuncu.adi + ' ' + Oyuncu.soyadi as oyuncu, Film.adi as filmadi 
from Film, FilmOyuncuKarakter, Oyuncu 
where Film.id = FilmOyuncuKarakter.film_id
and FilmOyuncuKarakter.oyuncu_id = Oyuncu.id
and Oyuncu.adi like 'm%'
-- Soru: James Cameron hangi trlerdeki filmleri ynetti? 
-- (Sorgudan ynetmen ad, soyad, film ad ve film tr dnsn)
select y.adi as yonetmenadi, y.soyadi as yonetmensoyadi, f.adi as filmadi, t.adi as filmturu  
from Yonetmen as y inner join Film as f on y.id = f.yonetmen_id
inner join FilmTur as ft on f.id = ft.film_id
inner join Tur as t on ft.tur_id = t.id
where y.adi = 'james' and y.soyadi = 'cameron'
-- Soru: Filmler hakkndaki tm bilgileri getiren tablo?
select distinct f.id as filmid, f.adi as filmadi, f.yapimyili as filmyapimyili, f.gisesi as filmgisesi,
y.adi + ' ' + y.soyadi as filmyonetmeni,
o.adi + ' ' + o.soyadi as filmoyuncusu, o.dogumtarihi as filmoyuncusudogumtarihi,
k.adisoyadi as filmkarakteri,
t.adi as filmturu
from Film as f inner join Yonetmen as y on f.yonetmen_id = y.id
inner join FilmOyuncuKarakter as fok on fok.film_id = f.id
inner join Oyuncu as o on fok.oyuncu_id = o.id
inner join Karakter as k on fok.karakter_id = k.id
inner join FilmTur as ft on f.id = ft.film_id
inner join Tur as t on ft.tur_id = t.id
-- INNER JOIN her iki (veya daha fazla) tabloda da en az bir eleme olan satrlar dndrr.
-- Eer soldaki tablonun sadaki tabloda elemesi yoksa o satrlar dndrmez. 
-- 2) OUTER JOIN:
-- elemeyen kaytlar da getirir
-- 2.1) LEFT JOIN:
select f.id as filmid, f.adi as filmadi, 
o.id as oyuncuid, o.adi + ' ' + o.soyadi as oyuncuadisoyadi 
from Film as f left outer join FilmOyuncuKarakter as fok on f.id = fok.film_id
left join Oyuncu as o on fok.oyuncu_id = o.id
go
select Film.id as filmid, Film.adi as filmadi,
Yonetmen.id as yonetmenid, Yonetmen.adi + ' ' + Yonetmen.soyadi as yonetmenadisoyadi 
from Film left join Yonetmen on Film.yonetmen_id = Yonetmen.id
-- Soldaki tabloya gre sadaki tablodan deerleri getir:
-- Filmlere gre Oyuncular getir, Filmlere gre Ynetmenleri getir.
-- LEFT JOIN soldaki tablodan btn satrlar sadaki tabloda elemeleri olmasa da dndrr.
-- 2.2) RIGHT JOIN:
select f.id as filmid, f.adi as filmadi, 
o.id as oyuncuid, o.adi + ' ' + o.soyadi as oyuncuadisoyadi 
from Film as f right join FilmOyuncuKarakter as fok on f.id = fok.film_id
right outer join Oyuncu as o on fok.oyuncu_id = o.id
go
select Film.id as filmid, Film.adi as filmadi,
Yonetmen.id as yonetmenid, Yonetmen.adi + ' ' + Yonetmen.soyadi as yonetmenadisoyadi 
from Film right join Yonetmen on Film.yonetmen_id = Yonetmen.id
-- Sadaki tabloya gre soldaki tablodan deerleri getir: 
-- Oyunculara gre Filmleri getir, Ynetmenlere gre Filmleri getir.
-- RIGHT JOIN sadaki tablodan btn satrlar soldaki tabloda elemeleri olmasa da dndrr.
-- 2.3) FULL JOIN:
select f.id as filmid, f.adi as filmadi, 
o.id as oyuncuid, o.adi + ' ' + o.soyadi as oyuncuadisoyadi 
from Film as f full outer join FilmOyuncuKarakter as fok on f.id = fok.film_id
full join Oyuncu as o on fok.oyuncu_id = o.id
go
select Film.id as filmid, Film.adi as filmadi,
Yonetmen.id as yonetmenid, Yonetmen.adi + ' ' + Yonetmen.soyadi as yonetmenadisoyadi 
from Film full join Yonetmen on Film.yonetmen_id = Yonetmen.id
-- Bu 2 sorguda FULL JOIN, LEFT JOIN gibi alyor.
-- FULL JOIN soldaki tablodan btn satrlar dndrr ve sadaki tablodan btn satrlar dndrr.
-- Sadaki tabloda elemesi olmayan soldaki tablo deerlerini ve soldaki tabloda elemesi olmayan
-- sadaki tablo deerlerini de dndrr.
-- 2.4) CROSS JOIN:
select Film.id as filmid, Film.adi as filmadi,
Yonetmen.id as yonetmenid, Yonetmen.adi + ' ' + Yonetmen.soyadi as yonetmenadisoyadi 
from Film cross join Yonetmen
-- WHERE kullanlmadnda CROSS JOIN iki (veya daha fazla) tablonun tm satrlarna gre 
-- Cartesian arpmlar'n dndrr.
-- 2 tablo iin: 
-- Sonu tablosu satr says = 1. Tablo satr says * 2. Tablo satr says
-- Film tablosu satr says:
select COUNT(*) from Film
-- 6
-- Yonetmen tablosu satr says:
select COUNT(*) from Yonetmen
-- 5
-- Sonu tablosu satr says:
select COUNT(*) from Film cross join Yonetmen
-- 30
-- WHERE kullanldnda CROSS JOIN, INNER JOIN gibi davranr.
select Film.id as filmid, Film.adi as filmadi,
Yonetmen.id as yonetmenid, Yonetmen.adi + ' ' + Yonetmen.soyadi as yonetmenadisoyadi 
from Film cross join Yonetmen
where Film.yonetmen_id = Yonetmen.id
go
select Film.id as filmid, Film.adi as filmadi,
Yonetmen.id as yonetmenid, Yonetmen.adi + ' ' + Yonetmen.soyadi as yonetmenadisoyadi 
from Film inner join Yonetmen
on Film.yonetmen_id = Yonetmen.id